/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.core;

import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleAnimation;
import dan200.computercraft.api.turtle.TurtleCommand;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.shared.platform.ContainerTransfer;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.InteractDirection;
import dan200.computercraft.shared.util.WorldUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

public class TurtleDropCommand
implements TurtleCommand {
    private final InteractDirection direction;
    private final int quantity;

    public TurtleDropCommand(InteractDirection direction, int quantity) {
        this.direction = direction;
        this.quantity = quantity;
    }

    @Override
    public TurtleCommandResult execute(ITurtleAccess turtle) {
        int transferred;
        if (this.quantity == 0) {
            turtle.playAnimation(TurtleAnimation.WAIT);
            return TurtleCommandResult.success();
        }
        class_2350 direction = this.direction.toWorldDir(turtle);
        ContainerTransfer source = TurtleUtil.getSelectedSlot(turtle);
        class_1937 world = turtle.getLevel();
        class_2338 oldPosition = turtle.getPosition();
        class_2338 newPosition = oldPosition.method_10093(direction);
        class_2350 side = direction.method_10153();
        ContainerTransfer inventory = PlatformHelper.get().getContainer((class_3218)world, newPosition, side);
        if (inventory != null) {
            transferred = source.moveTo(inventory, this.quantity);
        } else {
            class_1799 stack = turtle.getInventory().method_5434(turtle.getSelectedSlot(), this.quantity);
            if (stack.method_7960()) {
                transferred = -1;
            } else {
                turtle.getInventory().method_5431();
                transferred = stack.method_7947();
                WorldUtil.dropItemStack(world, oldPosition, direction, stack);
                world.method_8474(1000, newPosition, 0);
            }
        }
        return switch (transferred) {
            case -2 -> TurtleCommandResult.failure("No space for items");
            case -1 -> TurtleCommandResult.failure("No items to drop");
            default -> {
                turtle.playAnimation(TurtleAnimation.WAIT);
                yield TurtleCommandResult.success();
            }
        };
    }
}

